---
layout: docs
title: Download
description: Download Bootstrap Table to get the compiled CSS and JavaScript, source code, or include it with your favorite package managers like npm, bowser, and more.
group: getting-started
toc: true
---

## Source code

Source CSS, JavaScript, locales, and extensions, along with our docs.

<a href="{{ site.master_zip }}" class="btn btn-bd-primary" role="button">Download source</a>

## Clone or fork via GitHub

<a href="{{ site.repo }}" class="btn btn-bd-primary" role="button">Via GitHub</a>

## UNPKG

The folks over at [UNPKG](https://cdn.jsdelivr.net/npm/bootstrap-table@{{ site.current_version }}/dist/) graciously provide CDN support for CSS and JavaScript of Bootstrap table. Just use these links.

{% highlight html %}
<!-- Latest compiled and minified CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-table@{{ site.current_version }}/dist/bootstrap-table.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap-table@{{ site.current_version }}/dist/bootstrap-table.min.js"></script>
<!-- Latest compiled and minified Locales -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap-table@{{ site.current_version }}/dist/locale/bootstrap-table-zh-CN.min.js"></script>
{% endhighlight %}

## Package managers

### NPM

Install and manage Bootstrap table's CSS, JavaScript, locales, and extensions using [npm](https://www.npmjs.com/package/bootstrap-table).

{% highlight sh %}
npm install bootstrap-table
{% endhighlight %}

### bower

Install and manage Bootstrap table's CSS, JavaScript, locales, and extensions using [bower](http://bower.io/).

{% highlight sh %}
bower install bootstrap-table
{% endhighlight %}
